<?php

namespace App\Events;

use App\Models\Chat;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class NewMessage implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $chat;

    public function __construct(Chat $chat)
    {

        $this->chat = $chat;
    }

    public function broadcastOn()
    {
       
        return new Channel('chat.' . $this->chat->receiver_id);

        print_r($this->chat->receiver_id);
        die;
    }

    public function broadcastAs()
    {
        return 'new-message';
    }
}

