<?php

namespace App\Helpers;

class AgoraTokenHelper
{
    public static function generateToken($appID, $appCertificate, $channelName, $uid, $role, $expireTimeInSeconds = 3600)
    {
        $timestamp = now()->timestamp;
        $privilegeExpireTs = $timestamp + $expireTimeInSeconds;

        $message = $appID . $channelName . $uid . $role . $privilegeExpireTs;
        $signature = hash_hmac('sha256', $message, $appCertificate, true);
        $token = base64_encode($signature . $privilegeExpireTs);

        return $token;
    }
}
