<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Interest;

class InterestController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'type' => 'required|string|max:255',
        ]);

        $interest = Interest::create([
            'title' => $request->title,
            'type' => $request->type,
        ]);

        return response()->json([
            'message' => 'Interest added successfully',
            'data' => $interest,
        ], 201);
    }

    
    public function index()
    {
        $interests = Interest::all();

        return response()->json([
            'message' => 'Interests retrieved successfully',
            'data' => $interests,
        ]);
    }
}
