<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\UserInterest;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class UserInterestController extends Controller
{
    public function store(Request $request)
    {
        // Validate the input interests
        $request->validate([
            'interests' => 'required|string', // Interests must be a comma-separated string
        ]);
    
        // Get the currently authenticated user
        $user = Auth::user();
    
        // Store or update the user's interests
        $userInterest = UserInterest::updateOrCreate(
            ['user_id' => $user->id],
            ['interests' => $request->interests]
        );
    
        // Now search for other users with similar interests
        $inputInterests = explode(',', $request->interests);
    
        // Find users who have at least one matching interest
        $matchingUsers = UserInterest::where('user_id', '!=', $user->id) // Exclude the current user
            ->where(function ($query) use ($inputInterests) {
                foreach ($inputInterests as $interest) {
                    $query->orWhere('interests', 'LIKE', '%' . trim($interest) . '%');
                }
            })
            ->get()
            ->map(function ($userInterest) {
                return $userInterest->user; // Return user details
            });
    
        // Return the response with the matching users
        return response()->json([
            'message' => 'Interests saved successfully',
            'user_interests' => $userInterest,
            'matching_users' => $matchingUsers, // List of users with matching interests
        ]);
    }
    
}
