import { AgoraRTCError as AgoraRTCError_2 } from '@agora-js/shared';
import { AgoraRTCErrorCode } from '@agora-js/shared';
import { EventEmitter } from '@agora-js/shared';
import { NETWORK_STATE } from '@agora-js/shared';
import type { SDK_MODE } from '@agora-js/shared';
import type { UID } from '@agora-js/shared';

export declare interface AgoraApiExecutor<T> {
    onSuccess: (result: T) => void;
    onError: (err: AgoraRTCError_2) => void;
}

export declare enum AgoraEventUploadId {
    WORKER_EVENT = 156,
    AP_WORKER_EVENT = 160
}

export declare class AgoraLogger {
    private proxyServerURL?;
    private logLevel;
    private uploadState;
    private uploadLogWaitingList;
    private uploadLogUploadingList;
    private uploadErrorCount;
    private currentLogID;
    private url?;
    /** @internal */
    constructor();
    /** @internal */
    debug(...args: any): void;
    /** @internal */
    info(...args: any): void;
    /** @internal */
    warning(...args: any): void;
    /** @internal */
    warn(...args: any): void;
    /** @internal */
    error(...args: any): void;
    /** @internal */
    upload(...args: any): void;
    setLogLevel(level: number): void;
    enableLogUpload(): void;
    disableLogUpload(): void;
    /** @internal */
    setProxyServer(proxyServerURL?: string): void;
    /** @internal */
    prefix(prefix: string): EnhancedAgoraLogger;
    private log;
    private uploadLog;
    private appendLogToWaitingList;
    startUpload(): void;
    private uploadLogs;
    private uploadLogInterval;
    extLog: (level: number, argsWithStyle: string[]) => void;
}

/**
 * @ignore
 */
export declare class AgoraRTCError extends AgoraRTCError_2 {
    readonly name: string;
    constructor(code: AgoraRTCErrorCode, message?: string, data?: any);
    print(level?: "error" | "warning"): AgoraRTCError;
    throw(): never;
}

export { AgoraRTCErrorCode }

export declare enum AgoraRTCEvent {
    PUBLISH = "publish",
    SUBSCRIBE = "subscribe",
    WS_COMPRESSOR_INIT = "ws_compressor_init",
    SESSION_INIT = "session_init",
    JOIN_CHOOSE_SERVER = "join_choose_server",
    REQ_USER_ACCOUNT = "req_user_account",
    JOIN_GATEWAY = "join_gateway",
    REJOIN_GATEWAY = "rejoin_gateway",
    STREAM_SWITCH = "stream_switch",
    REQUEST_PROXY_WORKER_MANAGER = "request_proxy_worker_manager",
    REQUEST_PROXY_APPCENTER = "request_proxy_appcenter",
    FIRST_VIDEO_RECEIVED = "first_video_received",
    FIRST_AUDIO_RECEIVED = "first_audio_received",
    FIRST_VIDEO_DECODE = "first_video_decode",
    FIRST_AUDIO_DECODE = "first_audio_decode",
    ON_ADD_AUDIO_STREAM = "on_add_audio_stream",
    ON_ADD_VIDEO_STREAM = "on_add_video_stream",
    ON_UPDATE_STREAM = "on_update_stream",
    ON_REMOVE_STREAM = "on_remove_stream",
    USER_ANALYTICS = "req_user_analytics",
    PC_STATS = "pc_stats",
    UPDATE_REMOTE_RTPCAPABILITIES = "update_remote_rtpCapabilities"
}

export declare type AgoraRTCEventFirstRemoteFrame = AgoraRTCEvent.FIRST_AUDIO_DECODE | AgoraRTCEvent.FIRST_AUDIO_RECEIVED | AgoraRTCEvent.FIRST_VIDEO_DECODE | AgoraRTCEvent.FIRST_VIDEO_RECEIVED;

export declare type AgoraRTCEventOnGatewayStream = AgoraRTCEvent.ON_ADD_AUDIO_STREAM | AgoraRTCEvent.ON_ADD_VIDEO_STREAM | AgoraRTCEvent.ON_UPDATE_STREAM | AgoraRTCEvent.ON_REMOVE_STREAM;

export declare class AgoraRTCEventReport {
    private baseInfoMap;
    private proxyServer?;
    private eventUploadTimer;
    private setSessionIdTimer;
    private url?;
    private sids;
    private backupUrl?;
    private _appId?;
    private _aid;
    private keyEventUploadPendingItems;
    private normalEventUploadPendingItems;
    private apiInvokeUploadPendingItems;
    private apiInvokeCount;
    private apiInvokeLoggedCount;
    private ltsList;
    private lastSendNormalEventTime;
    private customReportCounterTimer?;
    private customReportCount;
    constructor();
    getBaseInfoBySessionId(sessionId: string): {
        info: EventReportBase;
        startTime: number;
        lastJoinSuccessTime?: number;
    };
    setAppId(appid: string): void;
    reportApiInvoke<T>(sessionId: string | null, params: EventReportReportAPIInvokeParams<T>, throttleTime?: number): AgoraApiExecutor<T>;
    sessionInit(sessionId: string, params: EventReportInitParams): void;
    joinChooseServer(sessionId: string, params: EventReportChooseServerParams): void;
    reqUserAccount(sessionId: string, params: EventReportReqUserAccountParams): void;
    joinGateway(sessionId: string, params: EventReportJoinGatewayParams): void;
    joinChannelTimeout(sessionId: string, timeout: number): void;
    publish(sessionId: string, params: EventReportPublishParams): void;
    subscribe(sessionId: string, params: EventReportSubscribeParams, isMassSubscribe?: boolean): void;
    wsCompressorInit(params: EventReportWsCompressorInitParams): void;
    firstRemoteVideoDecode(sessionId: string, eventType: AgoraRTCEventFirstRemoteFrame, uploadType: AgoraRTCEventUploadFirstRemoteFrame, params: EventFirstRemoteVideoFrameParams): void;
    firstRemoteFrame(sessionId: string, eventType: AgoraRTCEventFirstRemoteFrame, uploadType: AgoraRTCEventUploadFirstRemoteFrame, params: EventFirstRemoteFrameParams): void;
    pcStats(sessionId: string, params: EventPCStatsParams): void;
    updateRemoteRTPCapabilities(sessionId: string | null, params: EventUpdateRemoteRTPCapabilitiesParams): void;
    onGatewayStream(sessionId: string, eventType: AgoraRTCEventOnGatewayStream, uploadType: AgoraRTCEventUploadOnGatewayStream, params: EventOnGatewayStreamParams): void;
    streamSwitch(sessionId: string, params: EventReportStreamSwitchParams): void;
    requestProxyAppCenter(sessionId: string, params: EventReportRequestProxyAppCenterParams): void;
    requestProxyWorkerManager(sessionId: string, params: EventReportRequestProxyWorkerManagerParams): void;
    setProxyServer(url?: string): void;
    peerPublishStatus(sessionId: string, params: EventPeerPublishStatusParams): void;
    workerEvent(sessionId: string, params: IWorkerEvent): void;
    apworkerEvent(sessionId: string, params: IAPWorkerEvent): void;
    joinWebProxyAP(sessionId: string, params: IJoinWebProxyAP): void;
    WebSocketQuit(sessionId: string, params: IWebSocketQuit): void;
    sendCustomReportMessage(sessionId: string, params: EventCustomReportParams[]): Promise<void>;
    private sendApiInvoke;
    addSid(sid: string): void;
    removeSid(sid: string): void;
    private appendSessionId;
    send(item: AgoraRTCEventUploadItem, isKeyEvent: boolean): void;
    private doSend;
    private sendItems;
    private postDataToStatsCollector2;
    private postDataToStatsCollector;
    private createBaseInfo;
    reportResourceTiming(url: string, sessionId: string): void;
    extApiInvoke: (msgs: ExtensionApiInvokeMessage[]) => Promise<void>;
}

export declare type AgoraRTCEventUploadFirstRemoteFrame = AgoraRTCEventUploadType.FIRST_AUDIO_DECODE | AgoraRTCEventUploadType.FIRST_AUDIO_RECEIVED | AgoraRTCEventUploadType.FIRST_VIDEO_DECODE | AgoraRTCEventUploadType.FIRST_VIDEO_RECEIVED;

export declare interface AgoraRTCEventUploadItem {
    type: AgoraRTCEventUploadType;
    data: EventReportBase | newReportMessages;
    isPb?: boolean;
    id?: number;
}

export declare interface AgoraRTCEventUploadJsonItem {
    type: AgoraRTCEventUploadType;
    data: EventReportBase;
    isPb?: boolean;
}

export declare type AgoraRTCEventUploadOnGatewayStream = AgoraRTCEventUploadType.ON_ADD_AUDIO_STREAM | AgoraRTCEventUploadType.ON_ADD_VIDEO_STREAM | AgoraRTCEventUploadType.ON_UPDATE_STREAM | AgoraRTCEventUploadType.ON_REMOVE_STREAM;

export declare enum AgoraRTCEventUploadType {
    SESSION = "io.agora.pb.Wrtc.Session",
    JOIN_CHOOSE_SERVER = "io.agora.pb.Wrtc.JoinChooseServer",
    REQ_USER_ACCOUNT = "io.agora.pb.Wrtc.ReqUserAccount",
    JOIN_GATEWAY = "io.agora.pb.Wrtc.JoinGateway",
    RE_JOIN_GATEWAY = "io.agora.pb.Wrtc.ReJoinGateway",
    PUBLISH = "io.agora.pb.Wrtc.Publish",
    SUBSCRIBE = "io.agora.pb.Wrtc.Subscribe",
    WS_COMPRESSOR_INIT = "io.agora.pb.Wrtc.WsCompressorInit",
    STREAM_SWITCH = "io.agora.pb.Wrtc.StreamSwitch",
    AUDIO_SENDING_STOPPED = "io.agora.pb.Wrtc.AudioSendingStopped",
    VIDEO_SENDING_STOPPED = "io.agora.pb.Wrtc.VideoSendingStopped",
    REQUEST_PROXY_APPCENTER = "io.agora.pb.Wrtc.RequestProxyAppCenter",
    REQUEST_PROXY_WORKER_MANAGER = "io.agora.pb.Wrtc.RequestProxyWorkerManager",
    API_INVOKE = "io.agora.pb.Wrtc.ApiInvoke",
    FIRST_VIDEO_RECEIVED = "io.agora.pb.Wrtc.FirstVideoReceived",
    FIRST_AUDIO_RECEIVED = "io.agora.pb.Wrtc.FirstAudioReceived",
    FIRST_VIDEO_DECODE = "io.agora.pb.Wrtc.FirstVideoDecode",
    FIRST_AUDIO_DECODE = "io.agora.pb.Wrtc.FirstAudioDecode",
    ON_ADD_AUDIO_STREAM = "io.agora.pb.Wrtc.OnAddAudioStream",
    ON_ADD_VIDEO_STREAM = "io.agora.pb.Wrtc.OnAddVideoStream",
    ON_UPDATE_STREAM = "io.agora.pb.Wrtc.OnUpdateStream",
    ON_REMOVE_STREAM = "io.agora.pb.Wrtc.OnRemoveStream",
    JOIN_CHANNEL_TIMEOUT = "io.agora.pb.Wrtc.JoinChannelTimeout",
    PEER_PUBLISH_STATUS = "io.agora.pb.Wrtc.PeerPublishStatus",
    WORKER_EVENT = "io.agora.pb.Wrtc.WorkerEvent",
    AP_WORKER_EVENT = "io.agora.pb.Wrtc.APWorkerEvent",
    JOIN_WEB_PROXY_AP = "io.agora.pb.Wrtc.JoinWebProxyAP",
    WEBSOCKET_QUIT = "io.agora.pb.Wrtc.WebSocketQuit",
    USER_ANALYTICS = "io.agora.pb.Wrtc.UserAnalytics",
    AUTOPLAY_FAILED = "io.agora.pb.Wrtc.AutoplayFailed",
    PC_STATS = "io.agora.pb.Wrtc.PCStats",
    UPDATE_REMOTE_RTPCAPABILITIES = "io.agora.pb.Wrtc.UpdateRemoteRTPCapabilities"
}

export declare function apiInvoke(options?: {
    report?: AgoraRTCEventReport;
    reportResult?: boolean;
    className?: string;
    argsMap?: (self: any, ...args: any[]) => any[];
    throttleTime?: number;
}): ApiInvokeDecorator;

export declare type ApiInvokeDecorator = <T>(target: T, propertyKey: any, descriptor: TypedPropertyDescriptor<any>) => TypedPropertyDescriptor<any> | undefined;

export declare interface ApiInvokeMessage {
    tag?: string;
    sid: null | string;
    name: string;
    invokeId: number;
    result?: any;
    states?: any;
    options?: any;
    error?: string | AgoraRTCError_2;
    success: boolean;
    apiInvokeTime: number;
    lts?: number;
}

export declare type APIUploadData = [
...BaseUploadData,
[
string,
string | undefined,
string | undefined
]
];

export declare type BaseUploadData = [
number,
string,
LOG_TYPE,
string,
string | number | undefined
];

declare class EnhancedAgoraLogger {
    private logger;
    private prefixLists;
    constructor(logger: AgoraLogger);
    debug(...args: any): void;
    info(...args: any): void;
    warning(...args: any): void;
    error(...args: any): void;
    prefix(prefix: string): EnhancedAgoraLogger;
    popPrefix(): EnhancedAgoraLogger;
}

export declare const EVENT_BASE_TEMPLATE: EventReportBase;

/**
 * Parameters for reporting customized messages. Used when calling [AgoraRTCClient.sendCustomReportMessage]{@link IAgoraRTCClient.sendCustomReportMessage}.
 */
export declare interface EventCustomReportParams {
    /**
     * The ID of the message.
     */
    reportId: string;
    /**
     * The category of the message.
     */
    category: string;
    /**
     * The event name of the message.
     */
    event: string;
    /**
     * The label of the message.
     */
    label: string;
    /**
     * The value of the message.
     */
    value: number;
}

export declare interface EventFirstRemoteFrameMessage extends EventReportBase {
    eventType: AgoraRTCEventFirstRemoteFrame;
    peer: number;
    elapse: number;
    subscribeElapse: number;
    subscribeRequestid: number;
    p2pid: number;
    videowidth?: number;
    videoheight?: number;
}

export declare interface EventFirstRemoteFrameParams {
    peer: number;
    subscribeElapse: number;
    subscribeRequestid: number;
    p2pid: number;
    videowidth?: number;
    videoheight?: number;
}

export declare interface EventFirstRemoteVideoDecodeMessage extends EventReportBase {
    eventType: AgoraRTCEventFirstRemoteFrame;
    peer: number;
    elapse: number;
    subscribeElapse: number;
    subscribeRequestid: number;
    p2pid: number;
    videowidth?: number;
    videoheight?: number;
    apStart: number;
    apEnd: number;
    joinGwStart: number;
    joinGwEnd: number;
    pcStart: number;
    pcEnd: number;
    videoAddNotify: number;
    subscriberStart: number;
    subscriberEnd: number;
    firstDecodeFrame: number;
    state: number;
}

export declare interface EventFirstRemoteVideoFrameParams {
    peer: number;
    subscribeElapse: number;
    subscribeRequestid: number;
    p2pid: number;
    videowidth?: number;
    videoheight?: number;
    apStart: number;
    apEnd: number;
    joinGwStart: number;
    joinGwEnd: number;
    pcStart: number;
    pcEnd: number;
    videoAddNotify: number;
    subscriberStart: number;
    subscriberEnd: number;
    state: number;
    firstFrame?: number;
}

export declare interface EventJoinChannelTimeoutMessage extends EventReportBase {
    timeout: number;
    elapse: number;
}

export declare enum EventNameToID {
    SESSION = 26,
    JOIN_CHOOSE_SERVER = 27,
    REQ_USER_ACCOUNT = 196,
    JOIN_GATEWAY = 28,
    PUBLISH = 30,
    SUBSCRIBE = 29,
    WS_COMPRESSOR_INIT = 9430,
    STREAM_SWITCH = 32,
    AUDIO_SENDING_STOPPED = 33,
    VIDEO_SENDING_STOPPED = 34,
    REQUEST_PROXY_APPCENTER = 35,
    REQUEST_PROXY_WORKER_MANAGER = 36,
    API_INVOKE = 41,
    FIRST_VIDEO_RECEIVED = 348,
    FIRST_AUDIO_RECEIVED = 349,
    FIRST_VIDEO_DECODE = 350,
    FIRST_AUDIO_DECODE = 351,
    ON_ADD_AUDIO_STREAM = 352,
    ON_ADD_VIDEO_STREAM = 353,
    ON_UPDATE_STREAM = 356,
    ON_REMOVE_STREAM = 355,
    JOIN_CHANNEL_TIMEOUT = 407,
    PEER_PUBLISH_STATUS = 408,
    WORKER_EVENT = 156,
    AP_WORKER_EVENT = 160,
    JOIN_WEB_PROXY_AP = 700,
    WEBSOCKET_QUIT = 671,
    USER_ANALYTICS = 10000,
    AUTOPLAY_FAILED = 9178
}

export declare interface EventOnGatewayStreamMessage extends EventReportBase {
    eventType: AgoraRTCEventOnGatewayStream;
    peer: number;
    audio?: boolean;
    video?: boolean;
}

export declare interface EventOnGatewayStreamParams {
    peer: number;
    ssrc?: number;
    audio?: boolean;
    video?: boolean;
}

export declare interface EventPCStatsParams {
    startTime: number;
    eventElapse: number;
    iceconnectionsate: RTCIceConnectionState;
    dtlsstate: RTCDtlsTransportState | null;
    connectionstate: RTCPeerConnectionState;
    intSucc: number;
    error: null | string;
    selectedLocalCandidateProtocol: string;
    selectedLocalCandidateType: string;
    selectedLocalCandidateAddress: string;
    selectedRemoteCandidateProtocol: string;
    selectedRemoteCandidateType: string;
    selectedRemoteCandidateAddress: string;
    restartCnt: number;
    preallocation?: boolean;
}

export declare interface EventPeerPublishStatusMessage extends EventReportBase {
    joinChannelSuccessElapse: number;
    subscribeElapse: number;
    peerPublishDuration: number;
    peer: number;
    audiotag: number;
    videotag: number;
    peerPublishDurationVideo: number;
    peerPublishDurationAudio: number;
}

export declare interface EventPeerPublishStatusParams {
    subscribeElapse: number;
    peer: number;
    audioPublishDuration: number;
    videoPublishDuration: number;
}

export declare interface EventReportApiInvokeMessage extends EventReportBase {
    invokeId: number;
    execElapse: number;
    options?: string;
    execStates?: string;
    errorCode?: string;
    errorMsg?: string;
    execResult?: string;
    apiName: string;
}

export declare interface EventReportBase {
    sid: string;
    lts: number;
    success: boolean | null;
    cname: string | null;
    uid: number | null;
    peer?: number | null;
    cid: number | null;
    elapse: number | null;
    extend?: string | null;
    vid?: number | string;
    eventType?: string;
    apiName?: string;
}

export declare interface EventReportChooseServerParams {
    role?: "host" | "audience";
    lts: number;
    csAddr: string;
    ec: null | string;
    succ: boolean;
    serverList: null | string[];
    uid?: string;
    cid?: string;
    csIp?: string;
    unilbsServerIds?: string;
    extend?: string;
    opid: number;
    isHttp3?: 1 | -1;
    elapse?: number;
    corssRegionTagReq?: string;
    corssRegionTagRes?: string;
}

export declare interface EventReportInitParams {
    lts: number;
    buildFormat: number;
    cname: string;
    appid: string;
    mode: SDK_MODE;
    extend?: {
        rejoin?: boolean;
        recover?: boolean;
        willUploadConsoleLog?: boolean;
    };
    stringUid?: string;
    channelProfile?: number;
    channelMode?: number;
    isABTestSuccess?: number;
    lsid?: string;
    fsid?: string;
    clientType?: 20;
    clientRole?: number;
    info?: string;
}

export declare interface EventReportJoinChooseServerMessage extends EventReportBase {
    role?: "host" | "audience";
    eventType: AgoraRTCEvent.JOIN_CHOOSE_SERVER;
    eventElapse: number;
    chooseServerAddr: string;
    errorCode: string | null;
    chooseServerAddrList: string;
    chooseServerIp: string;
    unilbsServerIds?: string;
    extend?: string;
    opid: number;
    isHttp3?: 1 | -1;
    corssRegionTagReq?: string;
    corssRegionTagRes?: string;
}

export declare interface EventReportJoinGatewayMessage extends EventReportBase {
    eventType: AgoraRTCEvent.JOIN_GATEWAY;
    gatewayAddr: null | string;
    errorCode: null | string;
    errorMsg: null | string;
    eventElapse: number;
    firstSuccess: boolean;
    signalChannel: string;
    preload: number;
}

export declare interface EventReportJoinGatewayParams {
    vid?: string;
    lts: number;
    succ: boolean;
    ec: null | string;
    addr: null | string;
    uid: number;
    cid: number;
    firstSuccess: boolean;
    avoidJoinStartTime: number;
    isProxy: boolean;
    signalChannel: string;
    errorMsg?: string;
    preload?: boolean;
}

export declare interface EventReportMediaSendingStoppedParams {
    reason: string;
    succ: boolean;
}

export declare interface EventReportPublishMessage extends EventReportBase {
    eventType: AgoraRTCEvent.PUBLISH;
    eventElapse: number;
    errorCode: null | string;
    videoName?: string;
    audioName?: string;
    screenName?: string;
    audio: boolean;
    video: boolean;
    screenshare: boolean;
    publishRequestid: number;
    p2pid: number;
}

export declare interface EventReportPublishParams {
    eventElapse: number;
    succ: boolean;
    audio: boolean;
    video: boolean;
    screenshare: boolean;
    p2pid: number;
    publishRequestid: number;
    audioName?: string;
    videoName?: string;
    screenName?: string;
    ec: null | string;
    extend?: string;
}

export declare interface EventReportReJoinGatewayMessage extends NotContainSuccessPropertyEventReportBase {
    eventType: AgoraRTCEvent.REJOIN_GATEWAY;
    gatewayAddr: null | string;
    errorCode: null | string;
    eventElapse: number;
    isSuccess: 0 | 1;
    gatewayIp: string;
    port: string;
    isProxy: 0 | 1;
}

export declare interface EventReportReportAPIInvokeParams<T> {
    tag?: string;
    id?: string | number;
    name: string;
    options: any;
    states?: any;
    timeout?: number;
    reportResult?: boolean;
}

export declare interface EventReportRequestProxyAppCenterMessage extends EventReportBase {
    eventType: AgoraRTCEvent.REQUEST_PROXY_APPCENTER;
    eventElapse: number;
    APAddr: string;
    workerManagerList: null | string;
    response: string;
    errorCode: null | string;
}

export declare interface EventReportRequestProxyAppCenterParams {
    lts: number;
    succ: boolean;
    APAddr: string;
    workerManagerList: null | string;
    ec: null | string;
    response: string;
}

export declare interface EventReportRequestProxyWorkerManagerMessage extends EventReportBase {
    eventType: AgoraRTCEvent.REQUEST_PROXY_WORKER_MANAGER;
    eventElapse: number;
    workerManagerAddr: string;
    response: string;
    errorCode: null | string;
}

export declare interface EventReportRequestProxyWorkerManagerParams {
    lts: number;
    succ: boolean;
    workerManagerAddr: string;
    ec: null | string;
    response: string;
}

export declare interface EventReportReqUserAccountMessage extends EventReportBase {
    eventType: AgoraRTCEvent.REQ_USER_ACCOUNT;
    serverAddress: string;
    stringUid: string;
    errorCode: null | string;
    eventElapse: number;
}

export declare interface EventReportReqUserAccountParams {
    lts: number;
    elapse?: number;
    success: boolean;
    serverAddr: string;
    stringUid: string;
    uid: null | number;
    errorCode: null | string;
    extend: any;
}

export declare interface EventReportSessionInitMessage extends EventReportBase {
    eventType: AgoraRTCEvent.SESSION_INIT;
    appid: string;
    browser: string;
    buildFormat: number;
    build: string;
    mode: SDK_MODE;
    process: string;
    version: string;
    appType: number;
    stringUid?: string;
    channelProfile?: number;
    channelMode?: number;
    isABTestSuccess?: number;
    lsid?: string;
    fsid?: string;
    clientType?: number;
    clientRole?: number;
    serviceId?: string;
    extensionID?: string;
    info?: string;
}

export declare interface EventReportStreamSwitchMessage extends EventReportBase {
    eventType: AgoraRTCEvent.STREAM_SWITCH;
    isDual: boolean;
}

export declare interface EventReportStreamSwitchParams {
    lts: number;
    isdual: boolean;
    succ: boolean;
}

export declare interface EventReportSubscribeMessage extends EventReportBase {
    eventType: AgoraRTCEvent.SUBSCRIBE;
    eventElapse: number;
    errorCode: null | string;
    peerSuid?: string;
    video: boolean;
    audio: boolean;
    subscribeRequestid: number;
    p2pid: number;
    preSsrc?: number;
}

export declare interface EventReportSubscribeParams {
    succ: boolean;
    video: boolean;
    audio: boolean;
    peerid: UID;
    ec: null | string;
    subscribeRequestid: number;
    p2pid: number;
    eventElapse: number;
    preSsrc?: boolean;
}

export declare interface EventReportWsCompressorInitMessage extends EventReportBase {
    eventType: AgoraRTCEvent.WS_COMPRESSOR_INIT;
    eventElapse: number;
    status: 1 | 2;
}

export declare interface EventReportWsCompressorInitParams {
    status: boolean;
    ec: null | string;
    eventElapse: number;
}

export declare type EventUpdateRemoteRTPCapabilitiesMessage = EventUpdateRemoteRTPCapabilitiesParams & EventReportBase;

export declare interface EventUpdateRemoteRTPCapabilitiesParams {
    trackTypes: string;
    localCodecs: string;
    remoteCodecs: string;
}

export declare type EventUploadData = [...BaseUploadData, [string, string | undefined]];

export declare interface ExtensionApiInvokeMessage {
    name: string;
    result?: any;
    states?: any;
    options?: any;
    error?: string;
    success: boolean;
    apiInvokeTime: number;
    lts?: number;
}

export declare interface IAPWorkerEvent {
    sid?: string | null;
    cname?: string | null;
    cid?: number | Long_2 | null;
    lts?: number | Long_2 | null;
    ip?: string | null;
    uid?: number | Long_2 | null;
    success?: boolean | null;
    elapse?: number | Long_2 | null;
    peer?: number | Long_2 | null;
    ec?: number | null;
    sc?: number | null;
    serverIp?: string | null;
    firstSuccess?: boolean | null;
    responseTime?: number | null;
    serviceName?: string | null;
    responseDetail?: string | null;
}

export declare interface IJoinWebProxyAP {
    lts?: number | Long_2 | null;
    sid?: string | null;
    cname?: string | null;
    cid?: number | Long_2 | null;
    ip?: string | null;
    uid?: number | Long_2 | null;
    sucess?: number | null;
    elapse?: number | Long_2 | null;
    eventType?: string | null;
    apServerAddr?: string | null;
    turnServerAddrList?: string | null;
    errorCode?: string | null;
    unilbsServerIds?: string;
    extend?: string;
}

export declare interface InternalAPILog extends LogData {
    type: LOG_TYPE.INTERNAL_API;
    api: string;
    args?: string;
    result?: string;
}

export declare interface InternalEventLog extends LogData {
    type: LOG_TYPE.INTERNAL_EVENT;
    event: string;
    msg?: string;
}

export declare function isEventCustomReportParams(params: EventCustomReportParams): params is EventCustomReportParams;

export declare interface IWebSocketQuit {
    lts?: number | Long_2 | null;
    sid?: string | null;
    cname?: string | null;
    cid?: number | Long_2 | null;
    uid?: number | Long_2 | null;
    elapse?: number | Long_2 | null;
    succ?: number | null;
    errorCode?: string | null;
    ip?: string | null;
}

export declare interface IWorkerEvent {
    sid?: string | null;
    cname?: string | null;
    cid?: number | Long_2 | null;
    lts?: number | Long_2 | null;
    ip?: string | null;
    uid?: number | Long_2 | null;
    success?: boolean | null;
    elapse?: number | Long_2 | null;
    peer?: number | Long_2 | null;
    command?: string | null;
    actionType?: string | null;
    url?: string | null;
    payload?: string | null;
    serverCode?: number | null;
    code?: number | null;
    traceId?: string | null;
    workerType?: number | null;
    responseTime?: number | null;
    requestId?: number | Long_2 | null;
    packIndex?: number | null;
    requestByUser?: boolean | null;
    tid?: string | null;
    productType?: string | null;
}

export declare type Level = "info" | "debug" | "warning" | "error";

export declare const enum LOG_TYPE {
    MISC = 0,
    INTERNAL_EVENT = 1,
    PUBLIC_EVENT = 2,
    WEB_EVENT = 3,
    INTERNAL_API = 4,
    WEB_API = 5,
    PUBLIC_API = 6
}

export declare enum LOG_UPLOAD_STATE {
    FREE = "free",
    UPLOADING = "uploading"
}

export declare interface LogData {
    timestamp: number;
    level: Level;
    type: LOG_TYPE;
    module: string;
    instanceId?: string | number;
}

export declare interface LogErrorDetail {
    status: number;
    message: string;
    data?: any;
    headers?: any;
    networkState?: NETWORK_STATE;
    errorRange: number[];
}

export declare const logger: AgoraLogger;

export declare type LogInstance = any | [string?, (string | number)?];

declare class LogReportBus extends EventEmitter {
    private currentUploadLogID;
    reportLogUploadError(errorDetail: LogErrorDetail): void;
}

export declare const logReportBus: LogReportBus;

declare type Long_2 = any;

export declare interface MiscLog extends LogData {
    type: LOG_TYPE.MISC;
    msg: string;
}

export declare type MiscUploadData = [...BaseUploadData, [string]];

declare type newReportMessages = IWebSocketQuit | IJoinWebProxyAP | IWorkerEvent | IAPWorkerEvent;

declare interface NotContainSuccessPropertyEventReportBase {
    sid: string;
    lts: number;
    cname: string | null;
    uid: number | null;
    peer?: number | null;
    cid: number | null;
    elapse: number | null;
    extend?: string | null;
    vid?: number;
    apiName?: string;
}

export declare interface PublicAPILog extends LogData {
    type: LOG_TYPE.PUBLIC_API;
    api: string;
    args?: string;
    result?: string;
}

export declare interface PublicEventLog extends LogData {
    type: LOG_TYPE.PUBLIC_EVENT;
    event: string;
    msg?: string;
}

export declare const report: AgoraRTCEventReport;

export declare interface UploadLog {
    payload_str: string;
    log_level: number;
    log_item_id: number;
}

export declare interface WebAPILog extends LogData {
    type: LOG_TYPE.WEB_API;
    api: string;
    args?: string;
    result?: string;
}

export declare interface WebEventLog extends LogData {
    type: LOG_TYPE.WEB_EVENT;
    event: string;
    msg?: string;
}

export { }
