import { EventEmitter, RetryConfiguration } from '@agora-js/shared';

interface ConnectInfo {
    appId: string;
    areaCode: string | string[];
    cname: string;
    cid: number;
    sid: string;
    token: string | null;
    uid: number;
    vid: number;
}
/**
 * @ignore
 */
interface InspectConfiguration {
    interval: number;
    ossFilePrefix?: string;
    extraInfo?: string;
    inspectType?: ("supervise" | "moderation")[];
}

type TRteServiceName = "ChannelMediaRelay" | "LiveStreaming" | "ImageModeration" | "ContentInspect" | "DataStream" | "P2PChannel" | "PlanBConnection";
interface IRteService<T = any, R = any> {
    name: TRteServiceName;
    create: (...args: any[]) => T;
    createSubmodule?: (...args: any[]) => R;
}

declare class ContentInspect extends EventEmitter {
    name: string;
    private _connectionState;
    private get connectionState();
    private set connectionState(value);
    private _innerConnectionState;
    private sequence;
    private inspectStartTime;
    private workerManagerConnection;
    private workerConnection;
    private workerMessageLengthLimit;
    private inspectIntervalMinimum;
    private qualityRatio;
    private _connectInfo;
    private _cancelTokenSource;
    private _retryConfig;
    private wmSequence;
    private inspectInterval;
    private inspectTimer;
    private ossFilePrefix?;
    private extraInfo?;
    private _inspectType;
    private _inspectMode;
    private get inspectType();
    private set inspectType(value);
    private _quality;
    private qualityTimer;
    private get quality();
    private set quality(value);
    private _inspectId;
    private _needWorkUrlOnly;
    constructor(configuration: InspectConfiguration);
    init(connectInfo: ConnectInfo, retryConfig: Partial<RetryConfiguration>): Promise<void>;
    private requestAP;
    private connectWorkerManager;
    private connectWorker;
    private handleWorkerManagerEvents;
    private handleWorkerEvents;
    inspectImage: () => void;
    private requestToInspectImage;
    private generateRequestData;
    close(): void;
}
declare function checkContentInspectConfig(configuration: InspectConfiguration): void;
interface IContentInspectOptions {
    config: InspectConfiguration;
}
declare const ContentInspectService: IRteService<ContentInspect>;

export { ContentInspect, ContentInspectService, type IContentInspectOptions, checkContentInspectConfig };
