import { RetryConfiguration, TurnServerConfigWithMode, UID, Candidate, Setup, PayloadAttribute, Extmap, FingerPrint, EventEmitter, PromiseMutex, SDKStore, SDK_CODEC, AgoraPCStats, NetworkQuality as NetworkQuality$1, AgoraVideoReceiverStats, WebSocketQuitReason, ConnectionDisconnectedReason } from '@agora-js/shared';
import { IRemoteAudioTrack, IRemoteVideoTrack, IRemoteDataChannel, RemoteAudioTrack, RemoteVideoTrack, RemoteDataChannel, LocalTrack, LocalDataChannel, LowStreamParameter, VideoEncoderConfiguration, AudioEncoderConfiguration, MediaStats, LocalAudioTrackStats, LocalVideoTrackStats, RemoteAudioTrackStats, RemoteVideoTrackStats, AgoraRTCStats } from '@agora-js/media';

interface SignalSpec {
    clientId: string;
    retryConfig: RetryConfiguration;
    forceWaitGatewayResponse: boolean;
}
declare enum SignalConnectionState {
    CONNECTING = "connecting",
    CONNECTED = "connected",
    RECONNECTING = "reconnecting",
    CLOSED = "closed"
}
declare enum SignalRequestType {
    PING = "ping",
    PING_BACK = "ping_back",
    JOIN = "join_v3",
    REJOIN = "rejoin_v3",
    LEAVE = "leave",
    SET_CLIENT_ROLE = "set_client_role",
    PUBLISH = "publish",
    PUBLISH_DATASTREAM = "publish_datastream",
    UNPUBLISH = "unpublish",
    UNPUBLISH_DATASTREAM = "unpublish_datastream",
    SUBSCRIBE = "subscribe",
    PRE_SUBSCRIBE = "pre_subscribe",
    SUBSCRIBE_DATASTREAM = "subscribe_datastream",
    SUBSCRIBE_STREAMS = "subscribe_streams",
    UNSUBSCRIBE = "unsubscribe",
    UNSUBSCRIBE_DATASTREAM = "unsubscribe_datastream",
    UNSUBSCRIBE_STREAMS = "unsubscribe_streams",
    SUBSCRIBE_CHANGE = "subscribe_change",
    TRAFFIC_STATS = "traffic_stats",
    RENEW_TOKEN = "renew_token",
    SWITCH_VIDEO_STREAM = "switch_video_stream",
    DEFAULT_VIDEO_STREAM = "default_video_stream",
    SET_FALLBACK_OPTION = "set_fallback_option",
    GATEWAY_INFO = "gateway_info",
    CONTROL = "control",
    SEND_METADATA = "send_metadata",
    DATA_STREAM = "data_stream",
    PICK_SVC_LAYER = "pick_svc_layer",
    RESTART_ICE = "restart_ice",
    CONNECT_PC = "connect_pc",
    SET_VIDEO_PROFILE = "set_video_profile",
    SET_PARAMETER = "set_parameter",
    SET_RTM2_FLAG = "set_rtm2_flag"
}
declare enum SignalUploadType {
    WRTC_STATS = "wrtc_stats",
    WS_INFLATE_DATA_LENGTH = "ws_inflate_data_length",
    DENOISER_STATS = "denoiser_stats",
    EXTENSION_USAGE_STATS = "extension_usage_stats"
}
declare enum SignalNotifyType {
    ON_USER_ONLINE = "on_user_online",
    ON_USER_OFFLINE = "on_user_offline",
    ON_STREAM_FALLBACK_UPDATE = "on_stream_fallback_update",
    ON_PUBLISH_STREAM = "on_publish_stream",
    ON_UPLINK_STATS = "on_uplink_stats",
    ON_P2P_LOST = "on_p2p_lost",
    ON_REMOVE_STREAM = "on_remove_stream",
    ON_ADD_AUDIO_STREAM = "on_add_audio_stream",
    ON_ADD_VIDEO_STREAM = "on_add_video_stream",
    ON_TOKEN_PRIVILEGE_WILL_EXPIRE = "on_token_privilege_will_expire",
    ON_TOKEN_PRIVILEGE_DID_EXPIRE = "on_token_privilege_did_expire",
    ON_USER_BANNED = "on_user_banned",
    ON_USER_LICENSE_BANNED = "on_user_license_banned",
    ON_NOTIFICATION = "on_notification",
    ON_CRYPT_ERROR = "on_crypt_error",
    MUTE_AUDIO = "mute_audio",
    MUTE_VIDEO = "mute_video",
    UNMUTE_AUDIO = "unmute_audio",
    UNMUTE_VIDEO = "unmute_video",
    ON_P2P_OK = "on_p2p_ok",
    RECEIVE_METADATA = "receive_metadata",
    ON_DATA_STREAM = "on_data_stream",
    ON_RTP_CAPABILITY_CHANGE = "on_rtp_capability_change",
    ON_REMOTE_DATASTREAM_UPDATE = "on_remote_datastream_update",
    ON_REMOTE_FULL_DATASTREAM_INFO = "on_remote_full_datastream_info",
    ENABLE_LOCAL_VIDEO = "enable_local_video",
    DISABLE_LOCAL_VIDEO = "disable_local_video",
    ENABLE_LOCAL_AUDIO = "enable_local_audio",
    DISABLE_LOCAL_AUDIO = "disable_local_audio",
    ON_PUBLISHED_USER_LIST = "on_published_user_list"
}

interface PeerConnectionSpec {
    iceServers?: RTCIceServer[];
    turnServer?: TurnServerConfigWithMode;
    enableEncodedTransform?: boolean;
}
declare enum P2PConnectionDirection {
    SEND_ONLY = "SEND_ONLY",
    RECEIVE_ONLY = "RECEIVE_ONLY"
}

type WebSocketConnectionState = "connected" | "connecting" | "reconnecting" | "closed" | "failed";
type ReconnectMode = "retry" | "tryNext" | "recover";

interface ConfigDistributeLimitBitrate {
    uplink: {
        max_bitrate: number;
        min_bitrate: number;
    };
    low_stream_uplink?: {
        bitrate: number;
    };
    id: number;
}

/**
 * Information about a remote user. You can get this through [AgoraRTCClient.remoteUsers]{@link IAgoraRTCClient.remoteUsers}.
 */
interface IAgoraRTCRemoteUser {
    /**
     * The ID of the remote user.
     */
    uid: UID;
    /**
     * The subscribed audio track.
     */
    audioTrack?: IRemoteAudioTrack;
    /**
     * The subscribed video track.
     */
    videoTrack?: IRemoteVideoTrack;
    /**
     * Whether the remote user is sending an audio track.
     * - `true`: The remote user is sending an audio track.
     * - `false`: The remote user is not sending an audio track.
     */
    hasAudio: boolean;
    /**
     * Whether the remote user is sending a video track.
     * - `true`: The remote user is sending an audio track.
     * - `false`: The remote user is not sending an audio track.
     */
    hasVideo: boolean;
    /**
    * @ignore
    */
    dataChannels?: IRemoteDataChannel[];
}

declare class AgoraRTCRemoteUser implements IAgoraRTCRemoteUser {
    uid: UID;
    _uintid: number;
    _trust_audio_enabled_state_: boolean;
    _trust_video_enabled_state_: boolean;
    _trust_audio_mute_state_: boolean;
    _trust_video_mute_state_: boolean;
    _audio_muted_: boolean;
    _video_muted_: boolean;
    _audio_enabled_: boolean;
    _video_enabled_: boolean;
    _audio_added_: boolean;
    _video_added_: boolean;
    _is_pre_created: boolean;
    _video_pre_subscribed: boolean;
    _audio_pre_subscribed: boolean;
    _trust_video_stream_added_state_: boolean;
    _trust_audio_stream_added_state_: boolean;
    get hasVideo(): boolean;
    get hasAudio(): boolean;
    get audioTrack(): undefined | RemoteAudioTrack;
    get videoTrack(): undefined | RemoteVideoTrack;
    get dataChannels(): RemoteDataChannel[];
    constructor(uid: UID, uintid: number);
}

declare enum LocalTrackType {
    LocalVideoTrack = "videoTrack",
    LocalAudioTrack = "audioTrack",
    LocalVideoLowTrack = "videoLowTrack"
}
interface LocalTrackStruct {
    track: LocalTrack;
    id: string;
    ssrcs: SSRCMessage;
}
type PublishMessage = {
    stream_type: PubStreamType;
    attributes: Record<string, any>;
    ssrcs: SSRCMessage;
}[];
type UnPublishMessage = {
    stream_type: PubStreamType;
    ssrcs: SSRCMessage;
}[];
type PublishAnswer = {
    ssrcs: SSRCMessage;
    stream_type: PubStreamType;
    attributes?: RemoteConfig;
}[];
type SubscribeOrtc = {
    ssrcs: SSRCMessage;
    stream_type: Kind;
    attributes?: RemoteConfig;
}[];
type UnsubscribeMessage = {
    stream_type: Kind;
    ssrcId: number;
}[];
type MassUnsubscribeMessage = {
    users: {
        stream_id: UID;
        stream_type: MediaTypeMask;
    }[];
};
interface RemoteConfig {
    tcc?: boolean;
    remb?: boolean;
    twcc?: boolean;
}
type NetworkQuality = 0 | 1 | 2 | 3 | 4 | 5;
type MassUnsubscribeParams = {
    user: AgoraRTCRemoteUser;
    mediaType?: Kind;
};

interface RTPCapabilities {
    audioCodecs: PayloadAttribute[];
    videoCodecs: PayloadAttribute[];
    audioExtensions: Extmap[];
    videoExtensions: Extmap[];
}
interface ICEParameters {
    iceUfrag: string;
    icePwd: string;
}
interface DtlsParameters {
    fingerprints: FingerPrint[];
}
declare enum Kind {
    VIDEO = "video",
    AUDIO = "audio"
}
declare enum ICERestartType {
    UDP_RELAY = "udp_relay",
    UDP_TCP_RELAY = "udp_tcp_relay",
    TCP_RELAY = "tcp_relay",
    RELAY = "relay"
}
type EstablishParams = {
    iceParameters: ICEParameters;
    dtlsParameters: DtlsParameters;
    rtpCapabilities: RTPCapabilitiesBeforeMerge;
    offerSDP?: string;
};
type ConnectionParams = {
    iceParameters: ICEParameters;
    dtlsParameters: DtlsParameters;
    candidates: Candidate[];
    rtpCapabilities: RTPCapabilitiesWithDirection;
    setup: Setup;
    cname: string;
    preallocation?: boolean;
    preSSRCs?: PreSSRCMessage[];
};
type SSRCMessage = {
    ssrcId: number;
    rtx?: number;
}[];
type PreSSRCMessage = {
    kind: Kind;
    ssrcId: number;
    mslabel: string;
    rtx?: number;
};
interface RTPCapabilitiesWithDirection {
    send: RTPCapabilities;
    recv: RTPCapabilities;
}
interface RTPCapabilitiesBeforeMerge extends Partial<RTPCapabilitiesWithDirection> {
    sendrecv?: RTPCapabilities;
}

type Transmission = WebSocket | RTCDataChannel;

interface TransmissonInfo {
    transmitter: Transmission;
    close: () => void;
}

declare enum ExternalSignalRequestType {
    CALL = "call",
    CANDIDATE = "candidate",
    PUBLISH = "publish",
    UNPUBLISH = "unpublish",
    CONTROL = "control",
    RESTART_ICE = "restart_ice",
    ACK = "ack",
    RESPONSE = "response",
    JOIN = "join",
    CHECK = "check"
}

declare class P2PChannel extends EventEmitter {
    readonly isPlanB: any;
    private readonly store;
    private statsUploader;
    private connection?;
    private localTrackMap;
    private remoteUserMap;
    private localDataChannels;
    private remoteDataChannelMap;
    private pendingLocalTracks;
    private pendingRemoteTracks;
    private pendingLocalDataChannels;
    private pendingRemoteDataChannels;
    private readonly statsCollector;
    private shouldForwardP2PCreation;
    private iceFailedCount;
    private dtlsFailedCount;
    protected mutex: PromiseMutex;
    private _state;
    private _pcStatsUploadType;
    private _isStartRestartIce;
    private _restartTimer;
    private _isTryConnecting;
    private _iceError;
    private _forceTurn;
    private _isWaitPcToRePub;
    private get state();
    private set state(value);
    constructor(store: SDKStore, statsCollector: AgoraRTCStatsCollector);
    startP2PConnection(spec: PeerConnectionSpec): Promise<EstablishParams>;
    connect(connectParams: ConnectionParams): Promise<void>;
    updateRemoteRTPCapabilities(codecs: SDK_CODEC[]): void;
    getEstablishParams(): Promise<EstablishParams | void>;
    publishDataChannel(datachannels: LocalDataChannel[]): Promise<PublishDataChannelOptions[]>;
    publish(localTracks: LocalTrack[], enableVideoDualStream?: boolean, lowStreamParameter?: LowStreamParameter): AsyncGenerator<PublishMessage | undefined, void, PublishAnswer>;
    private doPublish;
    updateVideoStreamParameter(parameter: LowStreamParameter, type: Exclude<LocalTrackType, LocalTrackType.LocalAudioTrack>): Promise<void>;
    publishLowStream(lowStreamParameter: LowStreamParameter | undefined): AsyncGenerator<PublishMessage | undefined, void, PublishAnswer>;
    republish(): Promise<void>;
    reSubscribe(needSignal?: boolean): Promise<void>;
    unpublish(tracks: LocalTrack[]): Promise<UnPublishMessage | undefined>;
    unpublishDataChannel(dataChannels: LocalDataChannel[]): Promise<number[] | void>;
    unpublishLowStream(): Promise<UnPublishMessage | undefined>;
    private doUnpublish;
    subscribeDataChannel(user: AgoraRTCRemoteUser, remoteDataChannels: RemoteDataChannel[]): Promise<number[] | void>;
    subscribe(user: AgoraRTCRemoteUser, mediaType: Kind, ssrcId: number, rtxSsrcId?: number, subOrtc?: SubscribeOrtc): Promise<void>;
    massSubscribe(subscribeList: {
        user: AgoraRTCRemoteUser;
        mediaType: Kind;
        ssrcId: number;
        rtxSsrcId?: number;
    }[]): Promise<void>;
    massSubscribeNoLock(subscribeList: {
        user: AgoraRTCRemoteUser;
        mediaType: Kind;
        ssrcId: number;
        rtxSsrcId?: number;
    }[]): Promise<void>;
    unsubscribe(user: AgoraRTCRemoteUser, mediaType?: Kind, reserveTrack?: boolean): Promise<UnsubscribeMessage | undefined>;
    unsubscribeDataChannel(user: AgoraRTCRemoteUser, remoteDataChannels: RemoteDataChannel[]): Promise<number[] | undefined>;
    massUnsubscribe(unsubscribeList: MassUnsubscribeParams[]): Promise<MassUnsubscribeMessage | undefined>;
    massUnsubscribeNoLock(unsubscribeList: MassUnsubscribeParams[]): Promise<MassUnsubscribeMessage | undefined>;
    isPreSubScribe(ssrcId: number): boolean;
    muteRemote(user: AgoraRTCRemoteUser, kind: Kind): Promise<void>;
    unmuteRemote(user: AgoraRTCRemoteUser, kind: Kind): Promise<void>;
    unmuteRemoteNoLock(user: AgoraRTCRemoteUser, kind: Kind): Promise<void>;
    getAllTracks(filterLowVideoTrack?: boolean): LocalTrack[];
    getAllDataChannels(): LocalDataChannel[];
    reportPublishEvent(succ: boolean, ec: string | null, failedTracks?: LocalTrack[], isLowStream?: boolean, extend?: string): void;
    reportSubscribeEvent(succ: boolean, ec: string | null, user: AgoraRTCRemoteUser, mediaType: Kind): void;
    reset(): void;
    getStats(): AgoraPCStats | undefined;
    getRemoteVideoIsReady(ssrcId: number): boolean;
    getLocalAudioVolume(): number | undefined;
    getLocalVideoSize(): {
        width: number;
        height: number;
    } | undefined;
    getEncoderConfig(type: LocalTrackType): VideoEncoderConfiguration | AudioEncoderConfiguration | undefined;
    getLocalMedia(type: LocalTrackType): LocalTrackStruct | undefined;
    hasLocalMedia(): boolean;
    hasRemoteMedia(user?: AgoraRTCRemoteUser, kind?: Kind): boolean;
    hasRemoteMediaWithLock(user?: AgoraRTCRemoteUser, kind?: Kind): Promise<boolean>;
    getRemoteMedia(uid: UID): {
        audioTrack?: RemoteAudioTrack;
        videoTrack?: RemoteVideoTrack;
        audioSSRC?: number;
        videoSSRC?: number;
    };
    getAudioLevels(): {
        uid: UID;
        level: number;
    }[];
    disconnectForReconnect(): Promise<void>;
    hasPendingRemoteDataChannel(remoteUser: AgoraRTCRemoteUser | UID, streamId: number): boolean;
    setPendingRemoteDataChannel(remoteUser: AgoraRTCRemoteUser, id: number): void;
    hasPendingRemoteMedia(remoteUser: AgoraRTCRemoteUser | UID, mediaType: string): boolean;
    setPendingRemoteMedia(remoteUser: AgoraRTCRemoteUser, mediaType: Kind): void;
    restartICE(type?: ICERestartType): AsyncGenerator<ICEParameters, void, {
        remoteIceParameters: ICEParameters;
    }>;
    getUplinkNetworkQuality(): 0 | 1 | 2 | 3 | 4 | 5;
    getDownlinkNetworkQuality(): 0 | 1 | 2 | 3 | 4 | 5;
    muteLocalTrack(track: LocalTrack): Promise<void>;
    private handleMuteLocalTrack;
    private handleUnmuteLocalTrack;
    private handleUpdateVideoEncoder;
    private handleUpdateVideoSendParameters;
    private handleReplaceMixingTrack;
    private handleReplaceTrack;
    private replaceTrack;
    private filterTobePublishedTracks;
    private filterTobeUnpublishedTracks;
    private filterTobePublishedDataChannels;
    private filterTobeUnpublishedDataChannels;
    private bindLocalTrackEvents;
    private bindLocalAudioTrackEvents;
    private unbindLocalTrackEvents;
    private unbindLocalAudioTrackEvents;
    private bindRemoteTrackEvents;
    private unbindRemoteTrackEvents;
    private unbindAllRemoteTrackEvents;
    private createGatewayPublishMessage;
    private createGatewayUnpublishMessage;
    private assignLocalTracks;
    private withdrawLocalTracks;
    private bindConnectionEvents;
    private resetConnection;
    private filterTobeMutedTracks;
    private filterTobeUnmutedTracks;
    private createMuteMessage;
    private createUnmuteMessage;
    private filterTobeUnSubscribedTracks;
    private filterTobeUnSubscribedDataChannels;
    private createUnsubscribeMessage;
    private createUnsubscribeAllMessage;
    private withdrawRemoteTracks;
    updateBitrateLimit(bitrateLimit: ConfigDistributeLimitBitrate): Promise<void>;
    private handleGetRTCStats;
    private handleGetLocalVideoStats;
    private handleGetLocalAudioStats;
    private handleGetRemoteVideoStats;
    private handleGetRemoteAudioStats;
    isP2PDisconnected(): boolean;
    private mapPubResToRemoteConfig;
    private tryToUnmuteAudio;
    private bindStatsUploaderEvents;
    private unbindStatsUploaderEvents;
    requestReconnect(): Promise<void>;
    reconnectP2P(): Promise<void>;
    canPublishLowStream(): boolean;
    private throwIfTrackTypeNotMatch;
    private getLowVideoTrack;
    globalLock(): Promise<() => void>;
    private reportPCStats;
    private reportVideoFirstFrameDecoded;
    remoteMediaSsrcChanged(user: AgoraRTCRemoteUser, mediaType: Kind, ssrcId: number): Promise<boolean>;
    private unbindRtpTransceiver;
}

declare class AgoraRTCStatsCollector {
    private store;
    onStatsException?: (code: number, message: string, uid: UID) => void;
    onUploadPublishDuration?: (peer: UID, audioDuration: number, videoDuration: number, subscribeElapse: number) => void;
    onStatsChanged?: <K extends keyof MediaStats>(key: K, value: MediaStats[K]) => void;
    private localStats;
    private remoteStats;
    private updateStatsInterval?;
    trafficStats?: GatewayTrafficStats;
    private trafficStatsPeerList;
    private uplinkStats?;
    private exceptionMonitor;
    private p2pChannel?;
    private scalabilityMode;
    constructor(store: SDKStore);
    startUpdateStats(): void;
    stopUpdateStats(): void;
    reset(): void;
    getLocalAudioTrackStats(): LocalAudioTrackStats;
    getLocalVideoTrackStats(): LocalVideoTrackStats;
    getRemoteAudioTrackStats(uid?: UID): {
        [uid: string]: RemoteAudioTrackStats;
    };
    getRemoteNetworkQualityStats(uid?: UID): {
        [uid: string]: NetworkQuality$1;
    };
    getRemoteVideoTrackStats(uid?: UID): {
        [uid: string]: RemoteVideoTrackStats;
    };
    getRTCStats(): AgoraRTCStats;
    addLocalStats(type: LocalTrackType): void;
    removeLocalStats(type?: LocalTrackType): void;
    addRemoteStats(uid: UID): void;
    removeRemoteStats(uid?: UID): void;
    addP2PChannel(p2pChannel: P2PChannel): void;
    updateTrafficStats(stats: GatewayTrafficStats): void;
    updateUplinkStats(stats: GatewayUplinkStats): void;
    private updateStats;
    static isRemoteVideoFreeze(track: RemoteVideoTrack | undefined, stats: AgoraVideoReceiverStats, lastStats?: AgoraVideoReceiverStats): boolean;
    static isRemoteAudioFreeze(track?: RemoteAudioTrack): boolean;
    private isLocalVideoFreeze;
    private updateLocalStats;
    private updateRemoteStats;
}

declare enum PubStreamType {
    High = "high",
    Low = "low",
    Audio = "audio",
    Screen = "screen",
    ScreenLow = "screen_low"
}
interface PublishDataChannelOptions {
    streamId: number;
    ordered: boolean;
    maxRetransmits: number | null;
    metadata: string;
    channelId: number;
}
interface GatewayTrafficStats {
    B_acd: number;
    B_dnq: number;
    B_palr4: number;
    B_pvlr4: number;
    B_unq: number;
    ntp_offset?: number;
    peer_delay: {
        B_ad: number;
        B_deb: number;
        B_ealr4: number;
        B_ed: number;
        B_evlr4: number;
        B_st: number;
        B_vd: number;
        B_ppad: number;
        B_ppvd: number;
        B_punq: 0 | 1 | 2 | 3 | 4 | 5;
        B_pdnq: 0 | 1 | 2 | 3 | 4 | 5;
        peer_uid: UID;
    }[];
    timestamp: number;
}
interface GatewayUplinkStats {
    B_uab: number;
    B_ucl: number;
    B_ufl: number;
    B_fir: boolean;
}
declare enum MediaTypeMask {
    Nothing = 0,
    Audio = 1,
    LwoVideo = 2,
    Video = 4,
    Data = 8,
    DataStream0 = 256,
    DataStream1 = 512,
    DataStream2 = 1024,
    DataStream3 = 2048,
    DataStream4 = 4096,
    DataStream5 = 8192,
    DataStream6 = 16384,
    DataStream7 = 32768
}

type P2PPublishMessage = {
    kind: Kind;
    stream_type: PubStreamType;
    mid: string;
    ssrcs: SSRCMessage;
    isMuted?: boolean;
}[];
interface ConnectionParameters {
    iceParameters: ICEParameters;
    dtlsParameters: DtlsParameters;
}
type P2PEstablishParams = {
    sdp: string;
} & ConnectionParameters;

declare class P2PChannel2 extends EventEmitter {
    readonly isPlanB = false;
    private readonly store;
    private statsUploader;
    private sendConnection?;
    private recvConnection?;
    private localTrackMap;
    private remoteUserMap;
    private localDataChannels;
    private pendingLocalTracks;
    private pendingRemoteTracks;
    private readonly statsCollector;
    private dtlsFailedCount;
    protected sendMutex: PromiseMutex;
    protected recvMutex: PromiseMutex;
    private _state;
    private _restartStates;
    private reconnectInterval;
    private uploadUnplinkStarted;
    private uploadDownlinkStarted;
    private uplinkStateUploadInterval?;
    private downlinkStatsUploadInterval?;
    private get state();
    private set state(value);
    constructor(store: SDKStore, statsCollector: AgoraRTCStatsCollector);
    startP2PConnection(spec: PeerConnectionSpec, isDataChannel?: boolean): Promise<EstablishParams>;
    connect(connectParams: ConnectionParams): Promise<void>;
    startP2P(spec: PeerConnectionSpec, establishParams?: P2PEstablishParams): Promise<P2PEstablishParams>;
    p2pConnect(establishParams: P2PEstablishParams): Promise<void>;
    addRemoteCandidate(candidate: RTCIceCandidateInit, direction: P2PConnectionDirection): Promise<void>;
    publish(localTracks: LocalTrack[], enableVideoDualStream?: boolean, lowStreamParameter?: LowStreamParameter): AsyncGenerator<P2PPublishMessage>;
    unpublish(tracks: LocalTrack[]): Promise<UnPublishMessage | void>;
    private startUploadUplinkState;
    private stopUploadUplinkState;
    publishLowStream(lowStreamParameter: LowStreamParameter | undefined): AsyncGenerator<PublishMessage | undefined, void, PublishAnswer>;
    republish(): Promise<void>;
    unpublishLowStream(): Promise<UnPublishMessage | undefined>;
    subscribe(user: AgoraRTCRemoteUser, mediaType: Kind, ssrcId: number, mid: string): Promise<string | void>;
    mockSubscribe(user: AgoraRTCRemoteUser, mediaType: Kind, ssrcId: number, mid: string): Promise<string | void>;
    unsubscribe(user: AgoraRTCRemoteUser, mediaType?: Kind, reserveTrack?: boolean): Promise<void>;
    private startUploadDownlinkState;
    private stopUploadDownlinkState;
    getAllDataChannels(): LocalDataChannel[];
    massSubscribe(subscribeList: {
        user: AgoraRTCRemoteUser;
        mediaType: Kind;
        ssrcId: number;
        rtxSsrcId?: number;
    }[]): Promise<void>;
    massSubscribeNoLock(subscribeList: {
        user: AgoraRTCRemoteUser;
        mediaType: Kind;
        ssrcId: number;
        rtxSsrcId?: number;
    }[]): Promise<void>;
    massUnsubscribe(unsubscribeList: {
        user: AgoraRTCRemoteUser;
        mediaType?: Kind;
    }[]): Promise<MassUnsubscribeMessage | undefined>;
    massUnsubscribeNoLock(unsubscribeList: {
        user: AgoraRTCRemoteUser;
        mediaType?: Kind;
    }[]): Promise<MassUnsubscribeMessage | undefined>;
    muteRemote(user: AgoraRTCRemoteUser, kind: Kind): Promise<void>;
    unmuteRemote(user: AgoraRTCRemoteUser, kind: Kind): Promise<void>;
    unmuteRemoteNoLock(user: AgoraRTCRemoteUser, kind: Kind): Promise<void>;
    getAllTracks(filterLowVideoTrack?: boolean): LocalTrack[];
    reportPublishEvent(succ: boolean, ec: string | null, failedTracks?: LocalTrack[], isLowStream?: boolean, extend?: string): void;
    reportSubscribeEvent(succ: boolean, ec: string | null, user: AgoraRTCRemoteUser, mediaType: Kind): void;
    reset(): void;
    getStats(isDownlink?: boolean): AgoraPCStats | undefined;
    getRemoteVideoIsReady(ssrcId: number): boolean;
    getLocalAudioVolume(): number | undefined;
    getLocalVideoSize(): {
        width: number;
        height: number;
    } | undefined;
    getEncoderConfig(type: LocalTrackType): VideoEncoderConfiguration | AudioEncoderConfiguration | undefined;
    getLocalMedia(type: LocalTrackType): LocalTrackStruct | undefined;
    hasLocalMedia(): boolean;
    hasRemoteMedia(user?: AgoraRTCRemoteUser, kind?: Kind): boolean;
    hasRemoteMediaWithLock(user?: AgoraRTCRemoteUser, kind?: Kind): Promise<boolean>;
    getRemoteMedia(uid: UID): {
        audioTrack?: RemoteAudioTrack;
        videoTrack?: RemoteVideoTrack;
        audioSSRC?: number;
        videoSSRC?: number;
    };
    getAudioLevels(): {
        uid: UID;
        level: number;
    }[];
    disconnectForReconnect(): Promise<void>;
    hasPendingRemoteMedia(remoteUser: AgoraRTCRemoteUser | UID, mediaType: string): boolean;
    setPendingRemoteMedia(remoteUser: AgoraRTCRemoteUser, mediaType: Kind): void;
    restartICE(direction: P2PConnectionDirection, remoteIceParameter: ICEParameters): Promise<ICEParameters>;
    restartICE(direction: P2PConnectionDirection): Promise<void>;
    getUplinkNetworkQuality(): NetworkQuality;
    getDownlinkNetworkQuality(): NetworkQuality;
    muteLocalTrack(track: LocalTrack): Promise<void>;
    private handleMuteLocalTrack;
    private handleUnmuteLocalTrack;
    private handleUpdateVideoEncoder;
    private handleUpdateVideoSendParameters;
    private handleReplaceTrack;
    private filterTobePublishedTracks;
    private filterTobeUnpublishedTracks;
    private bindLocalTrackEvents;
    private bindLocalAudioTrackEvents;
    private unbindLocalTrackEvents;
    private unbindLocalAudioTrackEvents;
    private bindRemoteTrackEvents;
    private unbindRemoteTrackEvents;
    private unbindAllRemoteTrackEvents;
    private createGatewayPublishMessage;
    private createGatewayUnpublishMessage;
    private assignLocalTracks;
    private withdrawLocalTracks;
    private bindConnectionEvents;
    private unbindConnectionEvents;
    handleDisconnect(direction: P2PConnectionDirection): Promise<void>;
    private filterTobeMutedTracks;
    private filterTobeUnmutedTracks;
    private createMuteMessage;
    private createUnmuteMessage;
    private filterTobeUnSubscribedTracks;
    private createUnsubscribeMessage;
    private withdrawRemoteTracks;
    updateBitrateLimit(bitrateLimit: ConfigDistributeLimitBitrate): Promise<void>;
    private handleGetLocalVideoStats;
    private handleGetLocalAudioStats;
    private handleGetRemoteVideoStats;
    private handleGetRemoteAudioStats;
    isP2PDisconnected(): boolean;
    private tryToUnmuteAudio;
    private bindStatsUploaderEvents;
    private unbindStatsUploaderEvents;
    requestReconnect(): Promise<void>;
    reconnectP2P(): Promise<void>;
    canPublishLowStream(): boolean;
    private throwIfTrackTypeNotMatch;
    private getLowVideoTrack;
    globalLock(): Promise<() => void>;
    private reportVideoFirstFrameDecoded;
    remoteMediaSsrcChanged(user: AgoraRTCRemoteUser, mediaType: Kind, ssrcId: number): Promise<boolean>;
    isPreSubScribe(ssrcId: number): boolean;
    publishDataChannel(datachannels: LocalDataChannel[]): Promise<PublishDataChannelOptions[]>;
    unpublishDataChannel(dataChannels: LocalDataChannel[]): Promise<number[] | void>;
    subscribeDataChannel(user: AgoraRTCRemoteUser, remoteDataChannels: RemoteDataChannel[]): Promise<number[] | void>;
    unsubscribeDataChannel(user: AgoraRTCRemoteUser, remoteDataChannels: RemoteDataChannel[]): Promise<number[] | undefined>;
    hasPendingRemoteDataChannel(remoteUser: AgoraRTCRemoteUser | UID, streamId: number): boolean;
    setPendingRemoteDataChannel(remoteUser: AgoraRTCRemoteUser, id: number): void;
    preConnect(connectionParams: ConnectionParams): Promise<TransmissonInfo>;
    getEstablishParams(): EstablishParams;
    reSubscribe(needSignal?: boolean): Promise<void>;
    updateVideoStreamParameter(parameter: LowStreamParameter, type: Exclude<LocalTrackType, LocalTrackType.LocalAudioTrack>): Promise<void>;
    private unbindRtpTransceiver;
}

interface WebsocketUrl {
    host: string;
    port: string;
    proxy?: string;
}

declare abstract class BaseWebSocket extends EventEmitter {
    get url(): string | null;
    connectionID: number;
    currentURLIndex: number;
    urls: (WebsocketUrl | string)[];
    protected _reconnectMode: "retry" | "tryNext" | "recover";
    get reconnectMode(): "retry" | "tryNext" | "recover";
    set reconnectMode(newMode: "retry" | "tryNext" | "recover");
    reconnectReason?: WebSocketQuitReason;
    private _initMutex;
    protected readonly name: string;
    protected _state: WebSocketConnectionState;
    protected reconnectInterrupter?: () => void;
    get state(): WebSocketConnectionState;
    set state(newState: WebSocketConnectionState);
    protected websocket?: WebSocket;
    protected retryConfig: RetryConfiguration;
    protected reconnectCount: number;
    protected forceCloseTimeout: number;
    protected resetReconnectCount(reason: string): void;
    protected onlineReconnectListener?: Promise<void>;
    protected useCompress: boolean;
    tryDoubleDomain: boolean;
    use443PortOnly: boolean;
    protected wsInflateLength: number;
    protected wsDeflateLength: number;
    protected closeEstablishingWs?: (() => void) | undefined;
    protected store?: SDKStore;
    protected joinGatewayRecordIndex?: number;
    constructor(name: string, retryConfig: RetryConfiguration, useCompress?: boolean, tryDoubleDomain?: boolean, use443PortOnly?: boolean, store?: SDKStore);
    getConnection(): WebSocket | undefined;
    init(urls: (WebsocketUrl | string)[], forceCloseTimeout?: number): Promise<void>;
    close(failed?: boolean, lazyClose?: boolean): void;
    reconnect(reconnectMode?: ReconnectMode, reason?: WebSocketQuitReason): void;
    sendMessage(message: any, immediately?: boolean, isUint8ArrayMessage?: boolean): void;
    private setWsInflateData;
    getWsInflateData(): {
        wsInflateLength: number;
        wsDeflateLength: number;
    };
    private clearWsInflateData;
    private createWebSocketConnection;
    private reconnectWithAction;
    protected abstract chooseBestWebsocketConnection(url: WebsocketUrl | string, recordIndex?: number): Promise<WebSocket>;
}

declare class GatewayWebSocket extends BaseWebSocket {
    constructor(name: string, retryConfig: RetryConfiguration, useCompress?: boolean, tryDoubleDomain?: boolean, use443PortOnly?: boolean, store?: SDKStore);
    protected chooseBestWebsocketConnection(url: WebsocketUrl | string, recordIndex?: number): Promise<WebSocket>;
}

declare enum VideoCaptureCounter {
    HEIGHT = 2033,
    FRAME_RATE = 2034,
    WIDTH = 2035
}
declare enum VideoLowCaptureCounter {
    HEIGHT = 2072,
    FRAME_RATE = 2074,
    WIDTH = 2076
}
declare enum VideoSendCounter {
    FRAME_RATE = 2002,
    WIDTH = 2003,
    HEIGHT = 2004,
    PACKAGE_LOST = 2005,
    AVG_ENCODE = 2007,
    NACKS = 2009,
    PLIS = 2010,
    FIRS = 2011,
    BITRATE = 2012,
    PACKAGE_RATE = 2031,
    ADAPTATION = 2032,
    ACTUAL_ENCODED = 2060,
    BANDWIDTH = 2061,
    RETRANSMIT = 2062,
    TARGET_ENCODED = 2064,
    TRANSMIT = 2066,
    FREEZE = 2082,
    DISABLED = 2095,
    PLAYER_STATUS = 2128,
    QP_SUM = 2143,
    BYTES_RETRANSMIT = 2173,
    PACKAGES_RETRANSMIT = 2172,
    HUGE_FRAME_SENT = 2174,
    KEY_FRAMES_ENCODED = 2207
}
declare enum VideoSendLowCounter {
    BITRATE = 2069,
    PACKAGE_LOST = 2070,
    PACKAGE_RATE = 2071,
    HEIGHT = 2073,
    FRAME_RATE = 2075,
    WIDTH = 2077
}
declare enum VideoRecvCounter {
    JITTER = -1,
    PACKAGE_LOST = 2014,
    WIDTH = 2018,
    HEIGHT = 2019,
    FRAME_RATE = 2020,
    JITTER_BUFFER = 2023,
    CURRENT_DELAY = 2024,
    NACKS = 2026,
    PLIS = 2027,
    FIRS = 2028,
    BITRATE = 2029,
    PACKAGE_RATE = 2078,
    FREEZE = 2084,
    DISABLED = 2101,
    PLAYER_STATUS = 2129,
    QP_SUM = 2144,
    I_FRAME_DELAY = 2149,
    FRAMES_DROPPED = 2181,
    BYTES_RETRANSMIT = 2175,
    PACKAGES_RETRANSMIT = 2176,
    PACKAGES_DISCARDED = 2198,
    AVG_DECODE = 2200,
    AVG_PROCESSING_DELAY = 2202,
    AVG_ASSEMBLY_TIME = 2203,
    AVG_INTER_FRAME_DELAY = 2204,
    KEY_FRAMES_DECODED = 2206
}
declare enum VideoRenderCounter {
    FRAME_RATE_DECODE = 2021,
    FRAME_RATE_RENDER = 2022,
    FRAME_RATE_OUTPUT = 2155,
    FREEZE_TIME = 2109,
    FREEZE_TIME_RENDER = 2147,
    FREEZE_DURATION = 2156
}
declare enum AudioCaptureCounter {
    PCM_LEVEL = 2104
}
declare enum AudioSendCounter {
    PACKAGE_LOST = -1,
    LEVEL = 2038,
    BITRATE = 2039,
    PACKAGE_RATE = 2040,
    AEC_RETURN_LOSS = 2041,
    AEC_RETURN_LOSS_ENH = 2042,
    FREEZE = 2081,
    DISABLED = 2096,
    BYTES_RETRANSMIT = 2179,
    PACKAGES_RETRANSMIT = 2180
}
declare enum AudioRecvCounter {
    BITRATE = 2044,
    PACKAGE_LOST = 2045,
    PACKAGE_RATE = 2046,
    CURRENT_DELAY = 2047,
    JITTER_BUFFER = 2054,
    JITTER = 2055,
    FREEZE = 2083,
    DISABLED = 2102,
    PCM_LEVEL = 2105,
    PLAYER_STATUS = 2130,
    CONCEALED_SAMPLES = 2148,
    BYTES_RETRANSMIT = 2178,
    PACKAGES_RETRANSMIT = 2177,
    PACKAGES_DISCARDED = 2199,
    AVG_PROCESSING_DELAY = 2201
}
declare enum AudioRenderCounter {
    FREEZE_TIME = -1,
    LEVEL = 2043
}
interface UploadOutboundStats {
    high?: Record<VideoSendCounter | VideoCaptureCounter, number>;
    low?: Record<VideoSendLowCounter | VideoLowCaptureCounter, number>;
    audio?: Record<AudioSendCounter | AudioCaptureCounter, number>;
}
interface UploadInboundStats {
    peer: UID;
    video?: Record<VideoRecvCounter | VideoRenderCounter, number>;
    audio?: Record<AudioRecvCounter | AudioRenderCounter, number>;
}
declare enum TransportStatsCounter {
    RTT = 2006,
    CONN_TYPE = 801,
    STATS_UPDATE_INTERVAL = 2205
}
declare enum BaseTransportCounter {
    RTC_PEER_CONNECTION_STATE = 2219
}
interface UploadMixedStats {
    peer?: UID;
    video?: Record<VideoRenderCounter, number>;
    audio?: Record<AudioRenderCounter, number>;
    addition?: (Record<TransportStatsCounter, number | undefined> & Partial<Record<BaseTransportCounter, number>>) | Record<BaseTransportCounter, number>;
}
interface UploadStatsInfo {
    inbound?: UploadInboundStats[];
    outbound?: UploadOutboundStats[];
    misc?: UploadMixedStats[];
}

declare class P2PSignal extends EventEmitter {
    get connectionState(): SignalConnectionState;
    set connectionState(state: SignalConnectionState);
    get currentURLIndex(): number;
    private _disconnectedReason?;
    private _websocketReconnectReason?;
    private _connectionState;
    private reconnectToken?;
    private p2pToken;
    get url(): string | null;
    get rtt(): number;
    websocket: GatewayWebSocket;
    openConnectionTime?: number;
    private clientId;
    private lastMsgTime;
    private uploadCache;
    private uploadCacheInterval?;
    private rttRolling;
    private pingpongTimer?;
    private pingpongTimeoutCount;
    private joinResponse?;
    private multiIpOption?;
    private initError?;
    private spec;
    private store;
    private _external_signal;
    constructor(spec: SignalSpec, store: SDKStore);
    request(type: SignalRequestType, payload?: any, noNeedToReSend?: boolean, noNeedResponse?: boolean): Promise<any>;
    waitMessage<T = any>(type: SignalNotifyType, filter?: (message: T) => boolean): Promise<T>;
    uploadWRTCStats(stats: UploadStatsInfo): void;
    upload(type: SignalUploadType, payload?: any): void;
    send(type: SignalRequestType, payload?: any): void;
    sendExtensionMessage(type: ExternalSignalRequestType, payload?: any, noNeedResponse?: boolean): Promise<any>;
    init(urls: WebsocketUrl[]): Promise<any>;
    close(reason?: ConnectionDisconnectedReason): void;
    private join;
    reconnect(reconnectMode?: ReconnectMode, reason?: WebSocketQuitReason): void;
    private handleDataStream;
    private handleNotification;
    private handlePingPong;
    private handleWebsocketEvents;
    private onWebsocketMessage;
}

type TRteServiceName = "ChannelMediaRelay" | "LiveStreaming" | "ImageModeration" | "ContentInspect" | "DataStream" | "P2PChannel" | "PlanBConnection";
interface IRteService<T = any, R = any> {
    name: TRteServiceName;
    create: (...args: any[]) => T;
    createSubmodule?: (...args: any[]) => R;
}

interface IP2PChannelOptions {
    store: SDKStore;
    statsCollector: AgoraRTCStatsCollector;
}
interface IP2PSignalOptions {
    store: SDKStore;
    spec: SignalSpec;
}
declare const P2PChannelService: IRteService<P2PChannel2, P2PSignal>;

export { type IP2PChannelOptions, type IP2PSignalOptions, P2PChannel2, P2PChannelService };
