import { NullPrivateChannel } from './null-private-channel';
import { PresenceChannel } from './presence-channel';

/**
 * This class represents a null presence channel.
 */
export class NullPresenceChannel extends NullPrivateChannel implements PresenceChannel {
    /**
     * Register a callback to be called anytime the member list changes.
     */
    here(callback: Function): this {
        return this;
    }

    /**
     * Listen for someone joining the channel.
     */
    joining(callback: Function): this {
        return this;
    }

    /**
     * Send a whisper event to other clients in the channel.
     */
    whisper(eventName: string, data: any): this {
        return this;
    }

    /**
     * Listen for someone leaving the channel.
     */
    leaving(callback: Function): this {
        return this;
    }
}
